/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.pa.problem;

import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.fw.XMLEncodeable;
import com.ibm.hwmca.fw.pa.MetaData;
import com.ibm.hwmca.fw.pa.persist.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.pa.persist.ProblemPersistenceException;
import com.ibm.hwmca.fw.pa.problem.ProblemClosingException;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.problem.ProblemNotRegisteredException;
import com.ibm.hwmca.fw.pa.problem.ProblemOpeningException;
import com.ibm.hwmca.fw.pa.problem.ProblemPersistentData;
import com.ibm.hwmca.fw.pa.problem.history.HistoryEntry;
import com.ibm.hwmca.fw.pa.problem.history.ServiceHistory;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEvent;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.w3c.dom.Node;

public abstract class Problem
extends ServiceableEvent
implements Persistable,
XMLEncodeable {
    private static final String TRACE_MASKT = "XPAPROBT";
    private static final String TRACE_MASKF = "XPAPROBF";
    private static final String TRACE_MASKD = "XPAPROBD";
    public static final int PROBLEM_NUMBER_UNASSIGNED = Integer.MIN_VALUE;
    public static final int SEQUENCE_NUMBER_UNASSIGNED = Integer.MIN_VALUE;
    public static final int PROBLEM_STATE_CREATED = 0;
    public static final int PROBLEM_STATE_OPENED = 1;
    public static final int PROBLEM_STATE_CLOSED = 2;
    private static int nextProblemNumber;
    protected ServiceHistory serviceHistory;
    protected String shortDescription;
    protected int problemState = 0;
    protected int problemNumber = Integer.MIN_VALUE;
    protected int sequenceNumber = Integer.MIN_VALUE;
    protected long problemTimeStamp = System.currentTimeMillis();
    private MetaData metaData = null;
    protected String duplicateOf = null;
    protected int duplicateOfProblemNumber = Integer.MIN_VALUE;
    protected ArrayList associates = new ArrayList();
    protected String associateOf = null;
    protected boolean dumpPending = false;
    protected boolean vetoable = true;
    protected boolean isReplicatable = false;

    static final synchronized void setNextProblemNumber(int next) {
        if (next >= 9999) {
            next = 0;
        }
        nextProblemNumber = next;
    }

    private static synchronized int getNextProblemNumber() {
        return nextProblemNumber++;
    }

    public Problem() {
        this("Undescribed problem");
        this.metaData = new MetaData();
    }

    public Problem(String shortDescription) {
        this.shortDescription = shortDescription;
        this.metaData = new MetaData();
    }

    public Problem(PersistentData data) {
        super(((ProblemPersistentData)data).getParentPersistentData());
        ProblemPersistentData ppd = (ProblemPersistentData)data;
        this.serviceHistory = ppd.getServiceHistory();
        this.shortDescription = ppd.getShortDescription();
        this.problemState = ppd.getProblemState();
        this.problemNumber = ppd.getProblemNumber();
        this.sequenceNumber = ppd.getSequenceNumber();
        this.duplicateOf = ppd.getDuplicateOf();
        this.duplicateOfProblemNumber = ppd.getDuplicateOfProblemNumber();
        this.problemTimeStamp = ppd.getProblemTimeStamp();
        this.isReplicatable = ppd.isReplicatable();
        this.metaData = new MetaData();
        Trace.trace(TRACE_MASKD, "rebuilt problem from persistence");
        Trace.trace(TRACE_MASKD, "prob num=" + this.problemNumber);
        Trace.trace(TRACE_MASKD, "seq num=" + this.sequenceNumber);
        Trace.trace(TRACE_MASKD, "prob state=" + this.problemState);
    }

    public Problem(Node xfProblem) {
        this.fromXML(xfProblem);
    }

    public void addHistory(HistoryEntry entry) throws ProblemNotRegisteredException, PersistenceNotInitializedException, ProblemPersistenceException {
        if (this.serviceHistory == null) {
            this.serviceHistory = new ServiceHistory();
        }
        this.serviceHistory.addHistory(entry);
        ProblemManager.getProblemManager().changed(this);
    }

    public int getProblemState() {
        return this.problemState;
    }

    public void setProblemState(int problemState) {
        this.problemState = problemState;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public PersistentData getPersistentData() {
        ProblemPersistentData ppd = new ProblemPersistentData();
        ppd.setParentPersistentData(super.getPersistentData());
        ppd.setServiceHistory(this.serviceHistory);
        ppd.setShortDescription(this.shortDescription);
        ppd.setProblemState(this.problemState);
        ppd.setProblemNumber(this.problemNumber);
        ppd.setSequenceNumber(this.sequenceNumber);
        ppd.setProblemTimeStamp(this.problemTimeStamp);
        ppd.setDuplicateOf(this.duplicateOf);
        ppd.setDuplicateOfProblemNumber(this.duplicateOfProblemNumber);
        ppd.setReplicatable(this.isReplicatable);
        return ppd;
    }

    public void toXML(StringBuffer sb) {
    }

    public void toXML(StringBuffer sb, Class classResolving, Object instanceObj) {
        sb.append(XMLHelper.createTag(classResolving));
        Problem.getFields(instanceObj, sb, classResolving);
        Class superClass = classResolving.getSuperclass();
        try {
            Method[] allMethods = superClass.getMethods();
            int methodIndex = -1;
            for (int i = 0; i < allMethods.length; ++i) {
                if (!allMethods[i].getName().equals("toXML") || allMethods[i].getParameterTypes().length != 3 || !allMethods[i].getParameterTypes()[0].getName().equals("java.lang.StringBuffer") || !allMethods[i].getParameterTypes()[1].getName().equals("java.lang.Class") || !allMethods[i].getParameterTypes()[2].getName().equals("java.lang.Object")) continue;
                methodIndex = i;
            }
            Object[] parms = new Object[]{sb, superClass, instanceObj};
            if (methodIndex > 0) {
                allMethods[methodIndex].invoke((Object)this, parms);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sb.append("</" + classResolving.getName().substring(classResolving.getName().lastIndexOf(".") + 1) + ">");
    }

    public boolean isUpgradeData() {
        return false;
    }

    public final int getProblemNumber() {
        return this.problemNumber;
    }

    public final int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public final long getProblemTimeStamp() {
        return this.problemTimeStamp;
    }

    final synchronized void assignProblemNumber() {
        this.problemNumber = Problem.getNextProblemNumber();
    }

    public final String getShortDescription() {
        return this.shortDescription;
    }

    public final void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public ServiceHistory getServiceHistory() {
        return this.serviceHistory;
    }

    public void setServiceHistory(ServiceHistory serviceHistory) {
        this.serviceHistory = serviceHistory;
    }

    public abstract void open() throws ProblemOpeningException;

    public abstract void close() throws ProblemClosingException;

    public void fromXML(Node valueNode) {
        boolean index = false;
        boolean array = false;
        Field[] fields = null;
        if (XMLHelper.getAttributeValue(valueNode, "class") != null) {
            Node classNode = null;
            try {
                Node superNode;
                Class<?> thisClass = Class.forName(XMLHelper.getAttributeValue(valueNode, "class").substring(1));
                fields = thisClass.getDeclaredFields();
                classNode = XMLHelper.getWorkSection(valueNode, thisClass.getName().substring(thisClass.getName().lastIndexOf(".") + 1));
                for (int i = 0; i < fields.length; ++i) {
                    Node node;
                    int modifiers = fields[i].getModifiers();
                    if ((modifiers & 0x10) == 16 || (modifiers & 8) == 8 || (node = XMLHelper.getWorkSection(classNode, fields[i].getName())) == null) continue;
                    XMLHelper.getValueNativeObject(node, fields[i], this);
                }
                Class<?> superClass = thisClass.getSuperclass();
                if (superClass != null && (superNode = XMLHelper.getWorkSection(classNode, superClass.getName().substring(superClass.getName().lastIndexOf(".") + 1))) != null) {
                    this.fromXML(superNode);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isDuplicateOf() {
        if (this.duplicateOf != null) {
            Trace.trace(TRACE_MASKD, "duplicate is set. return true.");
            return true;
        }
        Trace.trace(TRACE_MASKD, "not set return false");
        return false;
    }

    public String getDuplicateOf() {
        return this.duplicateOf;
    }

    public void setDuplicateOf(String serviveableEventUniqueKey, int problemNumber) {
        Trace.trace(TRACE_MASKD, "--> setDuplicateOf");
        this.setDuplicateOfProblemNumber(serviveableEventUniqueKey, problemNumber);
        Trace.trace(TRACE_MASKD, "<-- setDuplicateOf");
    }

    public void setDuplicateOfProblemNumber(String serviveableEventUniqueKey, int problemNumber) {
        Trace.trace(TRACE_MASKD, "--> setDuplicateOfProblemNumber");
        if (this.duplicateOf == null) {
            Trace.trace(TRACE_MASKD, "setting the problem to be a duplicate of");
            Trace.trace(TRACE_MASKD, "uuid = " + serviveableEventUniqueKey);
            Trace.trace(TRACE_MASKD, "problem number = " + problemNumber);
            this.duplicateOf = serviveableEventUniqueKey;
            this.duplicateOfProblemNumber = problemNumber;
        } else {
            Trace.trace(TRACE_MASKD, "already a dup of " + this.duplicateOf);
            new IllegalStateException("Already a duplicate of " + this.duplicateOf);
        }
        Trace.trace(TRACE_MASKD, "<-- setDuplicateOfProblemNumber");
    }

    public boolean isAssociate() {
        return this.associateOf != null;
    }

    public String getAssociateOf() {
        return this.associateOf;
    }

    public boolean hasAssociates() {
        return this.associates.size() > 0;
    }

    public ArrayList getAssociates() {
        return this.associates;
    }

    public void setAssociateOf(String associateOf) {
        this.associateOf = associateOf;
    }

    public void setAssociates(ArrayList associates) {
        this.associates = associates;
    }

    public void setProblemNumber(int problemNumber) {
        this.problemNumber = problemNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void setProblemTimeStamp(long problemTimeStamp) {
        this.problemTimeStamp = problemTimeStamp;
    }

    public static void getFields(Object aObject, StringBuffer sb, Class aClass) {
        boolean index = false;
        boolean array = false;
        Field[] fields = null;
        Object superClass = null;
        Object baseClassName = null;
        fields = aClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            fields[i].getModifiers();
            if ((fields[i].getModifiers() & 0x10) == 16) continue;
            fields[i].setAccessible(true);
            try {
                Object fieldObj = fields[i].get(aObject);
                if (fieldObj == null) continue;
                sb.append(XMLHelper.createTag(fields[i].getType(), fields[i].getName()));
                if (fieldObj instanceof XMLEncodeable) {
                    ((XMLEncodeable)fieldObj).toXML(sb);
                } else if (fields[i].getType().getName().indexOf("[", 0) != -1) {
                    for (int y = 0; y < Array.getLength(fields[i]); ++y) {
                        sb.append(Array.get(fieldObj, y).toString());
                        if (y >= Array.getLength(fields[i]) - 1) continue;
                        sb.append(",");
                    }
                } else {
                    sb.append(fieldObj.toString());
                }
                sb.append("</" + fields[i].getName() + ">\n");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setReplicatable(boolean isReplicatable) {
        this.isReplicatable = isReplicatable;
    }

    public boolean isReplicatable() {
        return this.isReplicatable;
    }

    public boolean isDumpPending() {
        return this.dumpPending;
    }

    public void setDumpPending(boolean b) {
        this.dumpPending = b;
    }

    public boolean isVetoable() {
        return this.vetoable;
    }

    public void setVetoable(boolean b) {
        this.vetoable = b;
    }
}

